<?php
function my_theme_enqueue_styles() {
    wp_enqueue_style( 'parent-style', get_template_directory_uri() . '/style.css' );		/*Slick Slider*/	wp_enqueue_style( 'slick-css', get_stylesheet_directory_uri() .'/slick/slick.css' ); 	wp_enqueue_style( 'slick-theme-css', get_stylesheet_directory_uri() .'/slick/slick-theme.css' ); 	wp_enqueue_script( 'slick-js', get_stylesheet_directory_uri() .'/slick/slick.js', array(), '112222', true ); 
}
add_action( 'wp_enqueue_scripts', 'my_theme_enqueue_styles' );
if( function_exists('acf_add_options_page') ) {		acf_add_options_page(array(		'page_title' 	=> 'Homepage Slider Settings',		'menu_title'	=> 'Slider Settings',		'menu_slug' 	=> 'home-slider-settings',		'capability'	=> 'edit_posts',		'redirect'		=> false	));} 


function fn_homepage_slider(){	
	ob_start();	?>	 	
	<?php if( have_rows('slider_setting', 'option') ): ?>
	<div class="hm-banner-m">	
		<ul class="slide-main">	 
			<?php while( have_rows('slider_setting', 'option') ): the_row(); ?>		
			<li>				
			<?php 				
			$slide_img_id= get_sub_field("slide_image"); 				
			$slide_image = wp_get_attachment_image_src(  $slide_img_id, 'full' );				
			$srcset = wp_get_attachment_image_srcset(  $slide_img_id, array( 1800, 1280, 980, 480 ) ); 				
			$slide_title = get_sub_field('slide_title');				
			/* echo '<pre>';				print_r($slide_image[0]);				echo '</pre>'; */				?>					
			<div class="hm-banner hm-banner1"  style=" background: url(<?php echo $slide_image[0]; ?>) no-repeat; background-size: cover; ">				
			<div class="hm-bn-lft">					
			<div class="hm-bn-lft-txt">						
			<h1><?php the_sub_field('slide_title'); ?></h1>						
			<p><?php the_sub_field('slide_description'); ?></p>						
			<div class="hm-bn-btn">							
			<a href="<?php the_sub_field('slide_button_url'); ?>"><?php the_sub_field('slide_button_text'); ?></a>						
			</div>		
			
			<div class="hm-bn-btn1">							
				<?php the_sub_field('other_slide_content'); ?>						
			</div>	
						
			</div>				
			</div>								
			<div class="hm-bn-rft">					
			<div class="image_wrap-bn1">					
			<img loading="lazy" src="<?php echo $slide_image[0]; ?>" srcset="<?php echo esc_attr( $srcset ); ?>" alt="<?php echo strtolower($slide_title); ?>" height="auto" width="auto" class="wp-image-<?php echo $slide_img_id; ?>">		
			</div>				
			</div>			
			</div>		
			</li>		
			<?php endwhile; ?>	
		</ul>
	</div>
	<script>
	jQuery(document).ready(function(){	
		jQuery('.slide-main').slick({ 			  			
			dots: true,			  			
			infinite: true,				
			autoplay: false,			  			
			autoplaySpeed: 5000,			  			
			speed: 1000,				
			fade: true,						
			slidesToShow: 1,			  			
			adaptiveHeight: true,			  			
			slidesToScroll: 1, 			  			
			arrows: false,				
			accessibility: false,			
			respondTo: 'window',			  			
			pauseOnHover: true,			
			prevArrow:"<button type='button' class='slick-prev pull-left'><i class='fa fa-angle-left' aria-hidden='true'></i></button>",            
			nextArrow:"<button type='button' class='slick-next pull-right'><i class='fa fa-angle-right' aria-hidden='true'></i></button>"	
		});
	});
	</script>
	<?php endif; 
	return ob_get_clean();
}
add_shortcode("homepage_slider","fn_homepage_slider"); 


function fn_homepage_slider_static(){	ob_start();	?>	<div class="hm-banner-m">	<ul>		<li>			<div class="hm-banner">				<div class="hm-bn-lft">					<div class="hm-bn-lft-txt">						<h1>Giving You a Reason to Smile</h1>						<p>We practice a full scope of general and cosmeyic dentistry with expertise ranging from porcelain veneers to dental implants, crowns and bridges. We can now correct a wide variety of cosmetic dental problems, and can redesign your smile.						</p>						<div class="hm-bn-btn">							<a href="">Request an Appointment</a>						</div>						<div class="hm-bn-btn1">							<p><a href="tel:51920434-1550"><img src="https://dev.torontobeachdental.com/wp-content/uploads/2021/01/phone-icon.svg" alt=""> (519) 434-1550</a></p>							<p><a href="mailto:info@drsareendentisty.com"><img src="https://dev.torontobeachdental.com/wp-content/uploads/2021/01/message-icon.svg" alt=""> info@drsareendentisty.com</a></p>						</div>					</div>				</div>				<div class="hm-bn-rft">					<div class="image_wrap">						<img loading="lazy" src="https://dev.torontobeachdental.com/wp-content/uploads/2021/01/Toronto-Dental-Header.jpg" alt="" title="Toronto-Dental-Header" height="auto" width="auto"							srcset="https://dev.torontobeachdental.com/wp-content/uploads/2021/01/Toronto-Dental-Header.jpg 1800w, https://dev.torontobeachdental.com/wp-content/uploads/2021/01/Toronto-Dental-Header-1280x854.jpg 1280w, https://dev.torontobeachdental.com/wp-content/uploads/2021/01/Toronto-Dental-Header-980x654.jpg 980w, https://dev.torontobeachdental.com/wp-content/uploads/2021/01/Toronto-Dental-Header-480x320.jpg 480w"							sizes="(min-width: 0px) and (max-width: 480px) 480px, (min-width: 481px) and (max-width: 980px) 980px, (min-width: 981px) and (max-width: 1280px) 1280px, (min-width: 1281px) 1800px, 100vw" class="wp-image-5142"							>					</div>				</div>			</div>		</li>	</ul></div>	<?php 	return ob_get_clean();}add_shortcode("homepage_slider_static","fn_homepage_slider_static"); 

/******************************************************************/

function fn_service_posttype() { 
	register_post_type( 'services',

		array(
			'labels' => array(
				'name' => __( 'Services' ),
				'singular_name' => __( 'Service')
			),
			'public' => true,
			'has_archive' => false,
			'rewrite' => array('slug' => 'services','with_front' => false), 
			'supports' => array( 'title', 'revisions','editor','excerpt','thumbnail' ),
			
		)
	);
}
add_action( 'init', 'fn_service_posttype' );


function fn_services_listing(){
$exclude=get_the_ID();
$args = array( 
				'posts_per_page' => 12,
				'post_type' =>'services',
				'post_status' =>'publish',
				'orderby' => 'date', 
				'order' => 'ASC',
				'post__not_in' => array($exclude),
				
			);
	$the_query = new WP_Query( $args );
	ob_start();
	if ( $the_query->have_posts() ) {
	?>	<h2 class="section-title">Our Services</h2>
		<ul class="custom-sv-list">
		<?php	while ( $the_query->have_posts() ) : $the_query->the_post(); ?>
			<li><a href="<?php the_permalink(); ?>"><span><?php the_title(); ?></span></a></li>
		<?php	endwhile;	?>
		</ul>
	<?php
	}
	return ob_get_clean();
	wp_reset_postdata();
}
add_shortcode("services_listing","fn_services_listing"); 

