<?php



/*



Plugin Name: 123 Dentist Clinic Info



Plugin URI: http://aheadoftheweb.com/



Description: This plugin receives and stores HUB CIP objects.



Author: Ahead of the Web



Author URI: http://aheadoftheweb.com



Version: 0.63



*/







/**



 * Setup native automatic theme update functionality



 */



require 'update-checker/plugin-update-checker.php';



$myUpdateChecker = Puc_v4_Factory::buildUpdateChecker(



	'https://updates.aheadoftheweb.com/?action=get_metadata&slug=aow_cip',



	__FILE__,



	'aow_cip'



);











// Uninstall script



register_uninstall_hook(__FILE__,'aow_cip_child_deactivate');



// On uninstall delete all database entires made by the plugin



function aow_cip_child_deactivate(){



	delete_option( 'widget_cip_child_hours' );



	delete_option( 'cip_hours_title' );

	delete_option( 'cip_show_while_closed' );


	delete_option( 'cip_hours_daylength' );



	delete_option( 'aow_cip_object' );



	delete_option( 'aow_cip_id' );



}



add_action( 'admin_menu', 'aow_cip_menu_items' ); // action that allows the menu to show up







function aow_cip_menu_items(){



	// Create main menu instance in child dashboard



	add_menu_page( 'Overview', 'Clinic Information', 'manage_options', 'aow-cip-info', 'aow_cip_admin' );



	add_submenu_page('aow-cip-info' , 'Hours' , 'Hours' , 'manage_options' , 'aow-cip-hours' , 'aow_cip_hours');



	add_submenu_page(NULL,'Reset WP Touch', 'Reset WP Touch', 'manage_options', 'aow-reset-wp-touch','aow_cip_reset_wptouch');



	



}











function aow_cip_reset_wptouch()



{



	// using this as a placeholder in order to be able to have a special url to reset the WP Touch stuff for our own uses.



}







	add_filter( 'wptouch_setting_defaults', 'cip_setting_defaults');







// This function is used for the WP Touch plugin object



function cip_casttoclass($class, $object)



{



  return unserialize(preg_replace('/^O:\d+:"[^"]++"/', 'O:' . strlen($class) . ':"' . $class . '"', serialize($object)));



}







/* This is the function used to save and fetch settings in WP Touch */



function cip_setting_defaults($settings)



{







	$newsettings = array();



	$thepage = $_GET['page'];



	if (isset($_GET['push_cip']) && !isset($thepage) || isset($thepage) && $thepage == "aow-reset-wp-touch" || isset($thepage) && $thepage == "aow-cip-info" && (isset($_GET['push_cip']))): // because the function is run on every page load, we have to limit the times we allow it to execute the code.







	$wptouch_settingsvar = cip_casttoclass('stdClass',get_option('wpts_open')); // we're using this to get all saved WP Touch settings items so we don't overwrite changes.







	$json_hours = json_decode(get_option('aow_cip_object'),true);



	$cip = $json_hours['ClinicInfoPackage'];



	$address = $cip['ContactInfo']['Address'];



	$cinfo = $cip['ContactInfo']['ContactInfo'];



	$phone = $cinfo['Telephone'];



	$day_num = 1;



	$clinic_address = $address['Street'] . " ".$address['City'].", ".substr($address['PostalCode'],0,3). " ".substr($address['PostalCode'],3,3);







		$ampm = get_option("sc_ampmcase");



		$ampmseparator = get_option("sc_ampmseparator");



		$trailing = get_option("sc_trailingzero");



		$separator = get_option("sc_separator");







		$day = $json_hours['ClinicInfoPackage']['OpeningHours']['ClinicHours'];







		$monday_open =	$day[0][0];



		$monday_closing = 	$day[0][1];



		$monday_closed =	$day[0][2];



		$monday_note = isset($day[0][3]) ? $day[0][3] : "" ;



		$monday_string = ($monday_closed == 1) ? "Closed" : aow_cip_time_return($monday_open,0,$ampm,$trailing,$ampmseparator).$separator.aow_cip_time_return($monday_closing,0,$ampm,$trailing,$ampmseparator);



		$monday_string .= " ".$monday_note;







		$tuesday_open =	$day[1][0];



		$tuesday_closing =	 $day[1][1];



		$tuesday_closed =	$day[1][2];



		$tuesday_note = isset($day[1][3]) ? $day[1][3] : "";



		$tuesday_string = ($tuesday_closed == 1) ? "Closed" : aow_cip_time_return($tuesday_open,0,$ampm,$trailing,$ampmseparator).$separator.aow_cip_time_return($tuesday_closing,0,$ampm,$trailing,$ampmseparator);



		$tuesday_string .= " ".$tuesday_note;







		$wednesday_open =	$day[2][0];



		$wednesday_closing = $day[2][1];



		$wednesday_closed = $day[2][2];



		$wednesday_note = isset($day[2][3]) ? $day[2][3] : "";



		$wednesday_string = ($wednesday_closed == 1) ? "Closed" : aow_cip_time_return($wednesday_open,0,$ampm,$trailing,$ampmseparator).$separator.aow_cip_time_return($wednesday_closing,0,$ampm,$trailing,$ampmseparator);



		$wednesday_string .= " ".$wednesday_note;



		



		$thursday_open = $day[3][0];



		$thursday_closing = $day[3][1];



		$thursday_closed = $day[3][2];



		$thursday_note = isset($day[3][3]) ? $day[3][3] : "";



		$thursday_string = ($thursday_closed == 1) ? "Closed" : aow_cip_time_return($thursday_open,0,$ampm,$trailing,$ampmseparator).$separator.aow_cip_time_return($thursday_closing,0,$ampm,$trailing,$ampmseparator);



		$thursday_string .= " ".$thursday_note;







		$friday_open = $day[4][0];



		$friday_closing = $day[4][1];



		$friday_closed = $day[4][2];



		$friday_note = isset($day[4][3]) ? $day[4][3] : "";



		$friday_string = ($friday_closed == 1) ? "Closed" : aow_cip_time_return($friday_open,0,$ampm,$trailing,$ampmseparator) .$separator.aow_cip_time_return($friday_closing,0,$ampm,$trailing,$ampmseparator);



		$friday_string .= " ".$friday_note;







		$saturday_open = $day[5][0];



		$saturday_closing = $day[5][1];



		$saturday_closed = $day[5][2];



		$saturday_note = isset($day[5][3]) ? $day[5][3] : "";



		$saturday_string = ($saturday_closed == 1) ? "Closed" : aow_cip_time_return($saturday_open,0,$ampm,$trailing,$ampmseparator).$separator.aow_cip_time_return($saturday_closing,0,$ampm,$trailing,$ampmseparator);



		$saturday_string .= " ".$saturday_note;







		$sunday_open =	$day[6][0];



		$sunday_closing =	$day[6][1];



		$sunday_closed = $day[6][2];



		$sunday_note = isset($day[6][3]) ? $day[6][3] : "";



		$sunday_string = ($sunday_closed == 1 ) ? "Closed" :  aow_cip_time_return($sunday_open,0,$ampm,$trailing,$ampmseparator) .$separator.aow_cip_time_return($sunday_closing,0,$ampm,$trailing,$ampmseparator);



		$sunday_string .= " ".$sunday_note;







	/*



	// Hours - The old code that was resulting in the plugin outputting "We are open Monday Closed"



	$settings->show_hours = true;



	$settings->hours_sunday = (strlen($sunday_string) > 0) ? $sunday_string : "";



	$settings->hours_monday = (strlen($monday_string) > 0) ? $monday_string : "";



	$settings->hours_tuesday = (strlen($tuesday_string) > 0) ? $tuesday_string : "";



	$settings->hours_wednesday = (strlen($wednesday_string) > 0) ? $wednesday_string : "";



	$settings->hours_thursday = (strlen($thursday_string) > 0) ? $thursday_string : "";



	$settings->hours_friday = (strlen($friday_string) > 0) ? $friday_string : "";



	$settings->hours_saturday = (strlen($saturday_string) > 0) ? $saturday_string : "";



	$settings->map_address = (strlen($clinic_address) > 0) ? $clinic_address : "";



	$settings->cta_action = "tel:".$phone;



	$settings->open_show_menu_on_homepage = true;



	$settings->domain = "open";



	*/



	



	// Hours



	$settings->show_hours = true;



	if( strlen($sunday_string) > 0 && $sunday_string != "Closed " ){ $settings->hours_sunday = $sunday_string; }else{ $settings->hours_sunday = ""; }



	if( strlen($monday_string) > 0 && $monday_string != "Closed " ){ $settings->hours_monday = $monday_string; }else{ $settings->hours_monday = ""; }



	if( strlen($tuesday_string) > 0 && $tuesday_string != "Closed " ){ $settings->hours_tuesday = $tuesday_string; }else{ $settings->hours_tuesday = ""; }



	if( strlen($wednesday_string) > 0 && $wednesday_string != "Closed " ){ $settings->hours_wednesday = $wednesday_string; }else{ $settings->hours_wednesday = ""; }



	if( strlen($thursday_string) > 0 && $thursday_string != "Closed " ){ $settings->hours_thursday = $thursday_string; }else{ $settings->hours_thursday = ""; }



	if( strlen($friday_string) > 0 && $friday_string != "Closed " ){ $settings->hours_friday = $friday_string; }else{ $settings->hours_friday = ""; }



	if( strlen($saturday_string) > 0 && $saturday_string != "Closed " ){ $settings->hours_saturday = $saturday_string; }else{ $settings->hours_saturday = ""; }



	$settings->map_address = (strlen($clinic_address) > 0) ? $clinic_address : "";



	$settings->cta_action = "tel:".$phone;



	$settings->open_show_menu_on_homepage = true;



	$settings->domain = "open";



	



	foreach ($wptouch_settingsvar as $k => $v):



	if ($k == "show_hours" || $k == "hours_sunday" || $k == "hours_monday" || $k == "hours_tuesday" || $k == "hours_wednesday" || $k == "hours_thursday" || $k == "hours_friday" || $k == "hours_saturday" || $k == "map_address" || $k == "cta_action"):



	else:



	$settings->$k = $v;



	endif;



	endforeach;







	if (method_exists($settings,'save')): // make sure this object actually contains the save method so it doesn't cause the settings areas to crash if it doesn't exist.



	$settings_message = "Saving...<br />";



	$settings->save();



	$settings_message .= "Settings saved!";



		aow_cip_fetchcip($_GET['push_cip'],false,$settings_message);



		die;



	endif;







	endif;



	



	return $settings;



}







// Include file for Home View 



function aow_cip_admin(){



	



	if (isset($_POST['submit_btn'])):



		$clinic_id = isset($_POST['clinic_id']) ? $_POST['clinic_id'] : 0;



			if ($clinic_id > 0):



				update_option('aow_cip_id',$clinic_id);



			endif;



	endif;







	$clinic_id = get_option("aow_cip_id");



	



	require_once('includes/view-home.php');



}











// Include file for Hours Content Management



function aow_cip_hours(){



	require_once('includes/view-hours-content.php');



}







// Load custom CSS for styling widgets



add_action( 'wp_enqueue_scripts', 'aow_cip_register_plugin_styles' );







function aow_cip_register_plugin_styles() {



    wp_register_style( 'cip-child', plugins_url( 'aow_cip/css/contentshare.css' ) );

	wp_enqueue_style( 'cip-child' );

	

	/*

	$siteurl = site_url();



    $url = $siteurl . '/wp-content/plugins/' . basename(dirname(__FILE__)) . '/css/contentshare.css';



    echo "<link rel='stylesheet' type='text/css' href='$url' />\n";

	*/

}







/**



 * Adds Child_Hours widget.



 */



class Aow_cip_hours extends WP_Widget {



			/**



			 * Register widget with WordPress



			 */



			public function __construct() {



				parent::__construct(



					'aow_cip_hours', // Base ID



					__('AOW Clinic Hours', 'text_domain'), // Widget Name



					array( 'description' => __( 'Get Clinic Hours From CIP Object', 'text_domain' ), ) // Widget Description



				);



			}				  



			/**



			 * Front-end display of widget



			 */



			 



			 



			public function widget( $args , $instance ) {



					//Our variables from the widget settings.



					$title = apply_filters( 'widget_title' , $instance['title'] );



					$daylength = $instance[ 'daylength' ];



					$cip = get_option( 'aow_cip_object' );

					$show_while_closed = $instance[ 'cip_show_while_closed' ];

					$cipobject = json_decode($cip,true);







					// Output widget to page



					echo $args['before_widget'];



					if ( empty( $title ) ) {



						$title = "Our Hours";



					}

				

					$aow_cip_temp_closure = aow_cip_temp_closure();

					if( $aow_cip_temp_closure ){

						$hours = $aow_cip_temp_closure;
						
						if( $show_while_closed ){
							$hours .= populate_cip_hours_list($cipobject['ClinicInfoPackage']['OpeningHours']['ClinicHours'], $daylength);
						}

					}else{

						$hours = populate_cip_hours_list($cipobject['ClinicInfoPackage']['OpeningHours']['ClinicHours'], $daylength);

					}



					echo $args['before_title'] . $title . $args['after_title'];



					echo __( $hours , 'text_domain' );



					echo $args['after_widget'];



			}



				



			/**



			 * Back-end widget form



			 */



			 public function form( $instance ) {



			 	// Get title if there is one, if not set default title



				if ( isset( $instance[ 'title' ] ) && $instance[ 'title' ] != '' ) {



					$title = $instance[ 'title' ];



				}



				else {



					$title = __( 'Our Hours' , 'text_domain' );



				}



				// Create form for setting title



				?>



				<p>



               <label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Title:' ); ?></label> 



               <input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />

			

               </p>



               <?php 



				// Get day length if there is one, if not set default day length



				if ( isset( $instance[ 'daylength' ] ) && $instance[ 'daylength' ] != '' ) {



					$daylength = $instance[ 'daylength' ];



				}



				else {



					$daylength = 1;



				}



				// Create form for setting title



				?>



				<p>



               <label for="<?php echo $this->get_field_id( 'daylength' ); ?>"><?php _e( 'Length of Day:' ); ?></label><br /><br />



      	<input id="<?php echo $this->get_field_id('daylength'); ?>" name="<?php echo $this->get_field_name('daylength'); ?>" type="radio" value="1" <?php checked( '1', $daylength ); ?>/>



    	<label for="<?php echo $this->get_field_id('daylength'); ?>"><?php _e('Long Form (ie: Monday)'); ?></label>



        <p>



      	<input id="<?php echo $this->get_field_id('daylength'); ?>" name="<?php echo $this->get_field_name('daylength'); ?>" type="radio" value="2" <?php checked( '2', $daylength ); ?>/>



    	<label for="<?php echo $this->get_field_id('daylength'); ?>"><?php _e('Short Form (ie: Mon)'); ?></label>



    </p>


<?php 



				// Get day length if there is one, if not set default day length



				if ( isset( $instance[ 'cip_show_while_closed' ] ) && $instance[ 'cip_show_while_closed' ] != '' ) {



					$show_while_closed = $instance[ 'cip_show_while_closed' ];



				}



				else {



					$show_while_closed = 0;



				}



				// Create form for setting title



				?>



				<p>



               <label for="<?php echo $this->get_field_id( 'cip_show_while_closed' ); ?>"><?php _e( 'Show Hours While Closed:' ); ?></label><br /><br />



      	<input id="<?php echo $this->get_field_id('cip_show_while_closed'); ?>" name="<?php echo $this->get_field_name('cip_show_while_closed'); ?>" type="radio" value="0" <?php checked( '0', $show_while_closed ); ?>/>



    	<label for="<?php echo $this->get_field_id('cip_show_while_closed'); ?>"><?php _e('Do not show hours while clinic is under temporary closure'); ?></label>



        <p>



      	<input id="<?php echo $this->get_field_id('cip_show_while_closed'); ?>" name="<?php echo $this->get_field_name('cip_show_while_closed'); ?>" type="radio" value="1" <?php checked( '1', $show_while_closed ); ?>/>



    	<label for="<?php echo $this->get_field_id('cip_show_while_closed'); ?>"><?php _e('Yes show clinic hours under temporary closure message'); ?></label>



    </p>



    </p>



             



               <?php 



			}



			



			/**



			 * Sanitize widget form values as they are saved.



			 */



			public function update( $new_instance, $old_instance ) {



				$instance = array();



				$instance['title'] = ( ! empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';



				$instance['daylength'] = ( ! empty( $new_instance['daylength'] ) ) ? strip_tags( $new_instance['daylength'] ) : '';

				$instance['cip_show_while_closed'] = ( ! empty( $new_instance['cip_show_while_closed'] ) ) ? strip_tags( $new_instance['cip_show_while_closed'] ) : '';

		



				return $instance;



			}



} 







// class aow_cip







		function populate_cip_hours_list($json_obj,$daylength)



		{



			$ampm = get_option("sc_ampmcase");



			$ampmseparator = get_option("sc_ampmseparator");



			$trailing = get_option("sc_trailingzero");



			$separator = get_option("sc_separator");



			$day = $json_obj;











		$monday_open =	$day[0][0];



		$monday_closing = 	$day[0][1];



		$monday_closed =	$day[0][2];



		$monday_note = isset($day[0][3]) ? $day[0][3] : "" ;







		$tuesday_open =	$day[1][0];



		$tuesday_closing =	 $day[1][1];



		$tuesday_closed =	$day[1][2];



		$tuesday_note = isset($day[1][3]) ? $day[1][3] : "";







		$wednesday_open =	$day[2][0];



		$wednesday_closing = $day[2][1];



		$wednesday_closed = $day[2][2];



		$wednesday_note = isset($day[2][3]) ? $day[2][3] : "";







		$thursday_open = $day[3][0];



		$thursday_closing = $day[3][1];



		$thursday_closed = $day[3][2];



		$thursday_note = isset($day[3][3]) ? $day[3][3] : "";







		$friday_open = $day[4][0];



		$friday_closing = $day[4][1];



		$friday_closed = $day[4][2];



		$friday_note = isset($day[4][3]) ? $day[4][3] : "";







		$saturday_open = $day[5][0];



		$saturday_closing = $day[5][1];



		$saturday_closed = $day[5][2];



		$saturday_note = isset($day[5][3]) ? $day[5][3] : "";







		$sunday_open =	$day[6][0];



		$sunday_closing =	$day[6][1];



		$sunday_closed = $day[6][2];



		$sunday_note = isset($day[6][3]) ? $day[6][3] : "";







					//$hours = create_hours($json_decode, $daylength);



					$hours_ul = "<ul class='child_hours_ul'>";



					$hours_ul .= "<li>";



						if ($daylength == "long" || $daylength == 1):



							$hours_ul .= "<span class='child_dayofweek_long'><time day='1' itemprop='weekDay'>Monday:</time></span>";



						else:



							$hours_ul .= "<span class='child_dayofweek'>Mon:</span>";



						endif;



						$hours_ul .= "<span class='child_hours'>";



						if ($monday_closed == 1):



							$hours_ul .= "<span class='child_replace'>Closed";



							$hours_ul .= "</span>";



						else:



						$hours_ul .= "<span class='child_hours'>";



						$hours_ul .= "<time time='".aow_cip_time_return($monday_open,0,$ampm,$trailing,$ampmseparator)."' itemprop='startTime'>".aow_cip_time_return($monday_open,0,$ampm,$trailing,$ampmseparator)."</time>";



						$hours_ul .= "<span class='child_dash'>".$separator."</span>";



						$hours_ul .= "<time time='".aow_cip_time_return($monday_closing,1,$ampm,$trailing,$ampmseparator)."' itemprop='endTime'>".aow_cip_time_return($monday_closing,1,$ampm,$trailing,$ampmseparator)."</time>";



						$hours_ul .= "</span>";



						endif;



						if (strlen($monday_note) > 0): $hours_ul .= " <span class='child_note'>".$monday_note."</span>"; endif;



						$hours_ul .= "</span>";



					$hours_ul .= "</li>";



					$hours_ul .= "<li>";



						if ($daylength == "long" || $daylength == 1):



							$hours_ul .= "<span class='child_dayofweek_long'><time day='2' itemprop='weekDay'>Tuesday:</time></span>";



						else:



							$hours_ul .= "<span class='child_dayofweek'><time day='2' itemprop='weekDay'>Tue:</time></span>";



						endif;



						if ($tuesday_closed == 1):



							$hours_ul .= "<span class='child_replace'>Closed";



							if (strlen($tuesday_note) > 0): $hours_ul .= " <span class='child_note'>".$tuesday_note."</span>"; endif;



							echo "</span>";



						else:



						$hours_ul .= "<span class='child_hours'>";



						$hours_ul .= "<time time='".aow_cip_time_return($tuesday_open,0,$ampm,$trailing,$ampmseparator)."' itemprop='startTime'>".aow_cip_time_return($tuesday_open,0,$ampm,$trailing,$ampmseparator)."</time>";



						$hours_ul .= "<span class='child_dash'>".$separator."</span>";



						$hours_ul .= "<time time='".aow_cip_time_return($tuesday_closing,1,$ampm,$trailing,$ampmseparator)."' itemprop='endTime'>".aow_cip_time_return($tuesday_closing,1,$ampm,$trailing,$ampmseparator)."</time>";



		if (strlen($tuesday_note) > 0): $hours_ul .= " <span class='child_note'>".$tuesday_note."</span>"; endif;



						$hours_ul .= "</span>";



						endif;



					$hours_ul .= "</li>";



					$hours_ul .= "<li>";



						if ($daylength == "long" || $daylength == 1):



							$hours_ul .= "<span class='child_dayofweek_long'><time day='3' itemprop='weekDay'>Wednesday:</time></span>";



						else:



							$hours_ul .= "<span class='child_dayofweek'><time day='3' itemprop='weekDay'>Wed:</time></span>";



						endif;



						if ($wednesday_closed == 1):



							$hours_ul .= "<span class='child_replace'>Closed";



						if (strlen($wednesday_note) > 0): $hours_ul .= " <span class='child_note'>".$wednesday_note."</span>"; endif;



							$hours_ul .= "</span>";



						else:



						$hours_ul .= "<span class='child_hours'>";



						$hours_ul .= "<time time='".aow_cip_time_return($wednesday_open,0,$ampm,$trailing,$ampmseparator)."' itemprop='startTime'>".aow_cip_time_return($wednesday_open,0,$ampm,$trailing,$ampmseparator)."</time>";



						$hours_ul .= "<span class='child_dash'>".$separator."</span>";



						$hours_ul .= "<time time='".aow_cip_time_return($wednesday_closing,1,$ampm,$trailing,$ampmseparator)."' itemprop='endTime'>".aow_cip_time_return($wednesday_closing,1,$ampm,$trailing,$ampmseparator)."</time>";



						if (strlen($wednesday_note) > 0): $hours_ul .= " <span class='child_note'>".$wednesday_note."</span>"; endif;



						$hours_ul .= "</span>";



						endif;



					$hours_ul .= "</li>";



					$hours_ul .= "<li>";



						if ($daylength == "long" || $daylength == 1):



							$hours_ul .= "<span class='child_dayofweek_long'><time day='4' itemprop='weekDay'>Thursday:</time></span>";



						else:



							$hours_ul .= "<span class='child_dayofweek'><time day='4' itemprop='weekDay'>Thu:</time></span>";



						endif;



						if ($thursday_closed == 1):



							$hours_ul .= "<span class='child_replace'>Closed";



							if (strlen($thursday_note) > 0): $hours_ul .= " <span class='child_note'>".$thursday_note."</span>"; endif;



							$hours_ul .= "</span>";



						else:



						$hours_ul .= "<span class='child_hours'>";



						$hours_ul .= "<time time='".aow_cip_time_return($thursday_open,0,$ampm,$trailing,$ampmseparator)."' itemprop='startTime'>".aow_cip_time_return($thursday_open,0,$ampm,$trailing,$ampmseparator)."</time>";



						$hours_ul .= "<span class='child_dash'>".$separator."</span>";



						$hours_ul .= "<time time='".aow_cip_time_return($thursday_closing,1,$ampm,$trailing,$ampmseparator)."' itemprop='endTime'>".aow_cip_time_return($thursday_closing,1,$ampm,$trailing,$ampmseparator)."</time>";



						if (strlen($thursday_note) > 0): $hours_ul .= " <span class='child_note'>".$thursday_note."</span>"; endif;



						$hours_ul .= "</span>";



						endif;



					$hours_ul .= "</li>";



					$hours_ul .= "<li>";



						if ($daylength == "long" || $daylength == 1):



							$hours_ul .= "<span class='child_dayofweek_long'><time day='5' itemprop='weekDay'>Friday:</time></span>";



						else:



							$hours_ul .= "<span class='child_dayofweek'><time day='5' itemprop='weekDay'>Fri:</time></span>";



						endif;



						if ($friday_closed == 1):



							$hours_ul .= "<span class='child_replace'>Closed";



							if (strlen($friday_note) > 0): $hours_ul .= " <span class='child_note'>".$friday_note."</span>"; endif;



							$hours_ul .= "</span>";



						else:



						$hours_ul .= "<span class='child_hours'>";



						$hours_ul .= "<time time='".aow_cip_time_return($friday_open,0,$ampm,$trailing,$ampmseparator)."' itemprop='startTime'>".aow_cip_time_return($friday_open,0,$ampm,$trailing,$ampmseparator)."</time>";



						$hours_ul .= "<span class='child_dash'>".$separator."</span>";



						$hours_ul .= "<time time='".aow_cip_time_return($friday_closing,1,$ampm,$trailing,$ampmseparator)."' itemprop='endTime'>".aow_cip_time_return($friday_closing,1,$ampm,$trailing,$ampmseparator)."</time>";



						if (strlen($friday_note) > 0): $hours_ul .= " <span class='child_note'>".$friday_note."</span>"; endif;



						$hours_ul .= "</span>";



						endif;



					$hours_ul .= "</li>";



					$hours_ul .= "<li>";



						if ($daylength == "long" || $daylength == 1):



							$hours_ul .= "<span class='child_dayofweek_long'><time day='6' itemprop='weekEnd'>Saturday:</time></span>";



						else:



							$hours_ul .= "<span class='child_dayofweek'><time day='6' itemprop='weekEnd'>Sat:</time></span>";



						endif;



						if ($saturday_closed == 1):



							$hours_ul .= "<span class='child_replace'>Closed";



							if (strlen($saturday_note) > 0): $hours_ul .= " <span class='child_note'>".$saturday_note."</span>"; endif;



							$hours_ul .= "</span>";



						else:



						$hours_ul .= "<span class='child_hours'>";



						$hours_ul .= "<time time='".aow_cip_time_return($saturday_open,0,$ampm,$trailing,$ampmseparator)."' itemprop='startTime'>".aow_cip_time_return($saturday_open,0,$ampm,$trailing,$ampmseparator)."</time>";



						$hours_ul .= "<span class='child_dash'>".$separator."</span>";



						$hours_ul .= "<time time='".aow_cip_time_return($saturday_closing,1,$ampm,$trailing,$ampmseparator)."' itemprop='endTime'>".aow_cip_time_return($saturday_closing,1,$ampm,$trailing,$ampmseparator)."</time>";



						if (strlen($saturday_note) > 0): $hours_ul .= " <span class='child_note'>".$saturday_note."</span>"; endif;



						$hours_ul .= "</span>";



						endif;



					$hours_ul .= "</li>";



					$hours_ul .= "<li>";



						if ($daylength == "long" || $daylength == 1):



							$hours_ul .= "<span class='child_dayofweek_long'><time day='7' itemprop='weekEnd'>Sunday:</time></span>";



						else:



							$hours_ul .= "<span class='child_dayofweek'><time day='7' itemprop='weekEnd'>Sun:</time></span>";



						endif;



						if ($sunday_closed == 1):



							$hours_ul .= "<span class='child_replace'>Closed";



							if (strlen($sunday_note) > 0): $hours_ul .= " <span class='child_note'>".$sunday_note."</span>"; endif;



							$hours_ul .= "</span>";



						else:



						$hours_ul .= "<span class='child_hours'>";



						$hours_ul .= "<time time='".aow_cip_time_return($sunday_open,0,$ampm,$trailing,$ampmseparator)."' itemprop='startTime'>".aow_cip_time_return($sunday_open,0,$ampm,$trailing,$ampmseparator)."</time>";



						$hours_ul .= "<span class='child_dash'>".$separator."</span>";



						$hours_ul .= "<time time='".aow_cip_time_return($sunday_closing,1,$ampm,$trailing,$ampmseparator)."' itemprop='endTime'>".aow_cip_time_return($sunday_closing,1,$ampm,$trailing,$ampmseparator)."</time>";



						if (strlen($sunday_note) > 0): $hours_ul .= " <span class='child_note'>".$sunday_note."</span>"; endif;



						$hours_ul .= "</span>";



						endif;



					$hours_ul .= "</li>";



					$hours_ul .= "</ul>";



					return $hours_ul;	



			}











// Call Register Widget Function



add_action( 'widgets_init', 'aow_cip_load_widgets' );







// Register & Load Widgets



function aow_cip_load_widgets() {



	register_widget( 'aow_cip_hours' );



}







if (isset($_GET['push_cip']) && $_GET['push_cip'] > 0):



// check if the push_cip variable is set, then get the id and fetch the CIP object with this function.







	/* If we haven't saved this id, save it. If it exists already, then don't overwrite. */



	if (get_option('aow_cip_id') === false):



		update_option('aow_cip_id',$_GET['push_cip']);



	endif;







	// if the WP Touch plugin isn't installed and/or active, save just the CIP object.



		include_once( ABSPATH . 'wp-admin/includes/plugin.php' );



	if (!is_plugin_active('wptouch-pro-3/wptouch-pro-3.php')):



		$settings_message = "Saved...";



		aow_cip_fetchcip($_GET['push_cip'],false,$settings_message);



		die;



	endif;







endif;







/*



$cip should be an int. It is the ID of the Clinic



$update = false This parameter if set to true will not show any text. This is set to true when wordpress is updating plugins.



$msg = '' This is the message that will appear when the object is processed.



*/



function aow_cip_fetchcip($cip,$update=false,$msg='')



{



	$cip_contents = file_get_contents("https://hub.123dentist.com/cip-callback.php?get_cip=".$cip);



	json_decode($cip_contents);



	if( array_key_exists( 'check_error', $_GET ) && $_GET[ 'check_error' ] == 'true' ){
		echo 'file_get_contents = ' . file_get_contents("https://hub.123dentist.com/cip-callback.php?get_cip=".$cip). '<br>';
		echo 'json_last_error = ' . json_last_error() . '<br>';
		echo '$cip_content: <br>';
		var_dump($cip_contents );
	}



	// see if this is valid json.


	//var_dump( json_last_error() ); die();
	if (json_last_error() == JSON_ERROR_NONE ):



	update_option('aow_cip_object',$cip_contents);

	

	$cip_obj = json_decode($cip_contents);

	

	$cip_closure_status = FALSE;

	$cip_closure_message = FALSE;

	

	$cip_closure_status = $cip_obj->ClinicInfoPackage->ClosureStatus->temporary_closure;

	

	if( $cip_closure_status ){	

		

		$cip_closure_message = 'Sorry, we are temporarily closed</br>' . $cip_obj->ClinicInfoPackage->ClosureStatus->closure_reason;

		

		if( !$cip_closure_message ){

			

			$cip_closure_message = 'Sorry, we are temporarily closed.';

		

		}

	}

	

	update_option('aow_temp_closure',$cip_closure_status);

	update_option('aow_temp_closure_msg',$cip_closure_message);

	

	





		if (!$update):



			echo $msg."<br />";



			echo "You have successfully stored the CIP object!";



		endif;



	else:



		if (!$update):



			echo "Error: This is not a valid CIP object!";



		endif;







	endif;



}







// add the function that will be used when wordpress is updating plugins.



add_action( 'upgrader_process_complete', 'aow_cip_upgrader_ran', 10, 2 );







function aow_cip_upgrader_ran($upgrader_object, $options)



{



    // inspect $options



// check to see if the Clinic information plugin is in the queue to be updated.



	if (get_option('aow_cip_id') !== false && in_array("aow_cip/aow_cip.php",$options)):



		aow_cip_fetchcip(get_option('aow_cip_id'),true,'');



	endif;







}











// Plugin Installation Registration



register_activation_hook( __FILE__, 'aow_cip_sharecontent_activate' );







// Installation Function



function aow_cip_sharecontent_activate(){



	// Set admin URL



	



	// Trim admin URL



	//$sharecontentadminurl=trim($sharecontentadminurl,'/');



	// Enter admin URL into database



	//update_option( 'sc123_adminfeedurl', $sharecontentadminurl.'/?task=sharecontent_fetchfeed' );



}







if (!shortcode_exists('sc_hours')):



// Register shortcode versions of widgets



add_shortcode('sc_hours','aow_cip_hours_func');



endif;



add_shortcode('aow_clinic_hours','aow_cip_hours_func');









function aow_cip_temp_closure(){

	$cip_closure_status = get_option('aow_temp_closure');

	$cip_closure_message = get_option('aow_temp_closure_msg');

	

	if( $cip_closure_status ){

		return $cip_closure_message;

	}else{

		return FALSE;

	}

}





// Shortcode for hours content



function aow_cip_hours_func($atts){



	ob_start();



	



	if( is_array($atts) && $atts['length'] == 'short'){



		$daylength = 2;	



	}else{



		$daylength = 1;	



	}

	if( is_array($atts) && array_key_exists( 'showwhileclosed', $atts ) && $atts['showwhileclosed'] == 'true' ){
		$showwhileclosed = TRUE;	
	}else{
		$showwhileclosed = FALSE;	
	}



		$cip = get_option( 'aow_cip_object' );



		$cipobject = json_decode($cip,true);



	$aow_cip_temp_closure = aow_cip_temp_closure();

	if( $aow_cip_temp_closure ){

		$hours = $aow_cip_temp_closure;
		
		if( $showwhileclosed ){
			$hours .= populate_cip_hours_list($cipobject['ClinicInfoPackage']['OpeningHours']['ClinicHours'], $daylength);
		}

	}else{

		$hours = populate_cip_hours_list($cipobject['ClinicInfoPackage']['OpeningHours']['ClinicHours'], $daylength);

	}

	

	echo '<div class="hours_shortcode">';



	echo $hours;



	echo '</div>';



	return ob_get_clean();



}



add_filter('widget_text', 'do_shortcode');



// Misc functions used by widgets



// Function for formating time



function aow_cip_time_return($time, $end, $ampm = "uppercase", $trailingzeros, $ampmseparator, $twentyfourhourtime = "false" ){



	$twentyfourhourtime = $twentyfourhourtime;



	$colon = '';



	if ($ampmseparator == "yes"):		

		if( $twentyfourhourtime == 'true' ){

			$time = date("G:i a",strtotime(str_pad($time,4,'0',STR_PAD_LEFT)));

		}else{

			$time = date("g:i a",strtotime(str_pad($time,4,'0',STR_PAD_LEFT)));	

		}

	else:

		if( $twentyfourhourtime == 'true' ){

			$time = date("G:ia",strtotime(str_pad($time,4,'0',STR_PAD_LEFT)));

		}else{

			$time = date("g:ia",strtotime(str_pad($time,4,'0',STR_PAD_LEFT)));

		}

	endif;



	

	if( $ampm != 'none' ){

		if ($ampm == "uppercase"): $am = "AM"; $pm = 'PM'; else: $am = 'am'; $pm = 'pm'; endif;

	}else{

		 $am = "AM"; 

		 $pm = "PM";

	}





	if($time >= 1200){



		if($time == 1200) {



			$time = 1200;



		} elseif($time == 1230) {



			$time = 1230;



		} elseif( $twentyfourhourtime == 'true' ){

			

			$time = $time;

		

		} else {



			if (!is_array($time)):

				$time = ($time-1200);

			endif;

		

		}









		if ($trailingzeros == "no" && strpos(substr($time,-6),"00") !== FALSE):



		$time = str_replace( ":00","",$time);



		else:



		$time = substr_replace( $time , $colon , -2, 0);



		endif;



	/*	if($end == 1){



			$time .= $pm;



		}*/







		$time = str_replace("am",$am,$time);



		$time = str_replace("pm",$pm,$time);







		return $time;



		exit;



	}else{







		if ($trailingzeros == "no" && strpos(substr($time,-6),"00") !== FALSE):



		$time = str_replace(":00","",$time);



		else:



		$time = substr_replace( $time , $colon , -2, 0);



		endif;







		$time = str_replace("am",$am,$time);



		$time = str_replace("pm",$pm,$time);



		/*if($end == 1){



			$time .= $am;



		}*/



		return $time;



		exit;



	}



}







// Load custom CSS for styling widgets



add_action( 'wp_enqueue_scripts', 'register_cip_plugin_styles' );







function register_cip_plugin_styles() {



echo '<script src="//code.jquery.com/jquery-1.10.2.js"></script>';



?>



<style type="text/css">







.cip_note



{



margin-left:5px;	



}



.child_dayofweek_long { margin-right:2px; }



.child_hours_ul li



{



	clear:both;



}







.child_note > a



{



font-style:italic;



text-decoration:underline;



padding-left:5px;



}



  .note_div {



  color:#000000;



  background: rgba(255,255,255,.54);



  padding: 4px;



  white-space: nowrap;



  /*margin-top:22px;*/



  }



  .aotw_note



  {



	background:none!important;



  color:#000000;



  background: rgba(255,255,255,.54);



  padding: 4px;



  white-space: nowrap;



  border: 1px dotted;



  border-color:#FF0000!important;



  }



</style>



<script type='text/javascript'>



jQuery(document).ready(function()



{



//	$(".child_dayofweek_long").css('float','left');



	//$(".child_hours").css('float','left');







$(".child_note > a").click(function () {



  var $title = $(this).attr("title");



  var $new_note = jQuery('<li class="aotw_note" style="border-color:#F00000!important;"><div class="note_div">' + $(this).attr("title") + '</div></li>').hide();



  var $tooltip = $(this).parent().parent().parent().find(".aotw_note");







  if (!$tooltip.length) {



    $(this).parent().parent().parent().append($new_note);



	$new_note.show(800);



  } else {



	  $tooltip.hide(1000,function()



	  {



	  $tooltip.remove();



	  });



  }



});







});



</script>



<?php



}







add_action('init', 'customRSS');



function customRSS(){



        add_feed('hours', 'customRSSFunc');



}



function customRSSFunc(){



	$cip = get_option( 'aow_cip_object' );



	$json_hours = json_decode($cip,true);



	$day = $json_hours['ClinicInfoPackage']['OpeningHours']['ClinicHours'];







$ampm = get_option("sc_ampmcase");



$ampmseparator = get_option("sc_ampmseparator");



$trailing = get_option("sc_trailingzero");



$separator = get_option("sc_separator");















$monday_open =	$day[0][0];



$monday_closing = 	$day[0][1];



$monday_closed =	$day[0][2];



$monday_note = isset($day[0][3]) ? $day[0][3] : "" ;







$tuesday_open =	$day[1][0];



$tuesday_closing =	 $day[1][1];



$tuesday_closed =	$day[1][2];



$tuesday_note = isset($day[1][3]) ? $day[1][3] : "";







$wednesday_open =	$day[2][0];



$wednesday_closing = $day[2][1];



$wednesday_closed = $day[2][2];



$wednesday_note = isset($day[2][3]) ? $day[2][3] : "";







$thursday_open = $day[3][0];



$thursday_closing = $day[3][1];



$thursday_closed = $day[3][2];



$thursday_note = isset($day[3][3]) ? $day[3][3] : "";







$friday_open = $day[4][0];



$friday_closing = $day[4][1];



$friday_closed = $day[4][2];



$friday_note = isset($day[4][3]) ? $day[4][3] : "";







$saturday_open = $day[5][0];



$saturday_closing = $day[5][1];



$saturday_closed = $day[5][2];



$saturday_note = isset($day[5][3]) ? $day[5][3] : "";







$sunday_open =	$day[6][0];



$sunday_closing =	$day[6][1];



$sunday_closed = $day[6][2];



$sunday_note = isset($day[6][3]) ? $day[6][3] : "";



	



	if ($monday_closed == 1):



		$monday_hours_notes = "Closed";



	else:



	$monday_hours_notes = aow_cip_time_return($monday_open,0,$ampm,$trailing,$ampmseparator) . $separator . aow_cip_time_return($monday_closing,1,$ampm,$trailing,$ampmseparator);



	endif;



	if (strlen($monday_note) > 0): $monday_hours_notes .= " " . $monday_note; endif;







		if ($tuesday_closed == 1):



		$tuesday_hours_notes = "Closed";



	else:



	$tuesday_hours_notes = aow_cip_time_return($tuesday_open,0,$ampm,$trailing,$ampmseparator) . $separator . aow_cip_time_return($tuesday_closing,1,$ampm,$trailing,$ampmseparator);



	endif;



	if (strlen($tuesday_note) > 0): $tuesday_hours_notes .= " " . $tuesday_note; endif;







		if ($wednesday_closed == 1):



		$wednesday_hours_notes = "Closed";



	else:



	$wednesday_hours_notes = aow_cip_time_return($wednesday_open,0,$ampm,$trailing,$ampmseparator) . $separator . aow_cip_time_return($wednesday_closing,1,$ampm,$trailing,$ampmseparator);



	endif;



	if (strlen($wednesday_note) > 0): $wednesday_hours_notes .= " " . $wednesday_note; endif;







		if ($thursday_closed == 1):



		$thursday_hours_notes = "Closed";



	else:



	$thursday_hours_notes = aow_cip_time_return($thursday_open,0,$ampm,$trailing,$ampmseparator) . $separator . aow_cip_time_return($thursday_closing,1,$ampm,$trailing,$ampmseparator);



	endif;



	if (strlen($thursday_note) > 0): $thursday_hours_notes .= " " . $thursday_note; endif;







		if ($friday_closed == 1):



		$friday_hours_notes = "Closed";



	else:



	$friday_hours_notes = aow_cip_time_return($friday_open,0,$ampm,$trailing,$ampmseparator) . $separator . aow_cip_time_return($friday_closing,1,$ampm,$trailing,$ampmseparator);



	endif;



	if (strlen($friday_note) > 0): $friday_hours_notes .= " " . $friday_note; endif;







		if ($saturday_closed == 1):



		$saturday_hours_notes = "Closed";



	else:



	$saturday_hours_notes = aow_cip_time_return($saturday_open,0,$ampm,$trailing,$ampmseparator) . $separator . aow_cip_time_return($saturday_closing,1,$ampm,$trailing,$ampmseparator);



	endif;



	if (strlen($saturday_note) > 0): $saturday_hours_notes .= " " . $saturday_note; endif;







		if ($sunday_closed == 1):



		$sunday_hours_notes = "Closed";



	else:



	$sunday_hours_notes = aow_cip_time_return($sunday_open,0,$ampm,$trailing,$ampmseparator) . $separator . aow_cip_time_return($sunday_closing,1,$ampm,$trailing,$ampmseparator);



	endif;



	if (strlen($sunday_note) > 0): $sunday_hours_notes .= " " . $sunday_note; endif;







#$postCount = 5; // The number of posts to show in the feed



#$posts = query_posts('showposts=' . $postCount);



header('Content-Type: '.feed_content_type('rss-http').'; charset='.get_option('blog_charset'), true);



echo '<?xml version="1.0" encoding="'.get_option('blog_charset').'"?'.'>';



?>



<rss version="2.0"



        xmlns:content="http://purl.org/rss/1.0/modules/content/"



        xmlns:wfw="http://wellformedweb.org/CommentAPI/"



        xmlns:dc="http://purl.org/dc/elements/1.1/"



        xmlns:atom="http://www.w3.org/2005/Atom"



        xmlns:sy="http://purl.org/rss/1.0/modules/syndication/"



        xmlns:slash="http://purl.org/rss/1.0/modules/slash/"



        <?php do_action('rss2_ns'); ?>>



<channel>



        <title><?php bloginfo_rss('name'); ?> - Feed</title>



        <atom:link href="<?php self_link(); ?>" rel="self" type="application/rss+xml" />



        <link><?php bloginfo_rss('url') ?></link>



        <description><?php bloginfo_rss('description') ?></description>



        <lastBuildDate><?php echo mysql2date('D, d M Y H:i:s +0000', get_lastpostmodified('GMT'), false); ?></lastBuildDate>



        <language><?php echo get_option('rss_language'); ?></language>



        <sy:updatePeriod><?php echo apply_filters( 'rss_update_period', 'hourly' ); ?></sy:updatePeriod>



        <sy:updateFrequency><?php echo apply_filters( 'rss_update_frequency', '1' ); ?></sy:updateFrequency>



        <?php do_action('rss2_head'); ?>







                <item>



                        <title>Monday</title>



                        <description><![CDATA[<?php echo $monday_hours_notes; ?>]]></description>



                </item>



                <item>



                        <title>Tuesday</title>



                        <description><![CDATA[<?php echo $tuesday_hours_notes; ?>]]></description>



                </item>



                <item>



                        <title>Wednesday</title>



                        <description><![CDATA[<?php echo $wednesday_hours_notes; ?>]]></description>



                </item>



                <item>



                        <title>Thursday</title>



                        <description><![CDATA[<?php echo $thursday_hours_notes; ?>]]></description>



                </item>



                <item>



                        <title>Friday</title>



                        <description><![CDATA[<?php echo $friday_hours_notes; ?>]]></description>



                </item>



                <item>



                        <title>Saturday</title>



                        <description><![CDATA[<?php echo $saturday_hours_notes; ?>]]></description>



                </item>



                <item>



                        <title>Sunday</title>



                        <description><![CDATA[<?php echo $sunday_hours_notes; ?>]]></description>



                </item>



</channel>



</rss>



<?php



}





function get_hours_from_array( $day_array, $time='open' ){

	// Localize variables

	$day = $day_array;

	$time = $time;

	

	// Set our own variables to define variables of aow_cip_time_return function

	$end = '';

	$ampm = 'none';

	$trailingzeros = 'yes';

	$ampmseparator = 'no';

	$twentyfourhourtime = 'true';

	

	// Figure out if day is open, if so pass either the openning hours or closing hours based on variable

	if( $day[ 2 ] && $day[ 2 ] == '1' ){

		return 'Closed';

	}else{

		if ( $time && $time == 'open' ){

			//return $day[ 0 ];

			return aow_cip_time_return( $day[ 0 ], $end, $ampm, $trailingzeros, $ampmseparator, $twentyfourhourtime );

		}else if ( $time && $time == 'closed' ){

			return aow_cip_time_return( $day[ 1 ], $end, $ampm, $trailingzeros, $ampmseparator, $twentyfourhourtime);

		}

	}

}



// Function for sanitizing characters from descriptions

function sanitize_desciption( $description ){

	$d = $description;

	

	$d = str_replace( "<br>", " ", $d );

	$d = str_replace( "<br />", " ", $d );

	$d = str_replace( "/n", " ", $d );

	$d = str_replace( "u0027", "'", $d );

	$d = str_replace( "u2019", "'", $d );

	

		

	

	return $d;

}



// JSON-LD Schema output 

//add_action( 'wp_head', 'write_jsonld_schema');

		

function write_jsonld_schema(){

	

	// Get clinic's most recent cip in JSON format and decode into array

	$cip_json = get_option( 'aow_cip_object' );

	$cip = json_decode( $cip_json, true );

	$cip_raw = NULL;

	global $cip_raw;

	$cip_raw = $cip;

	

	

	// Build all variables we will use in the schema

	$clinic_url = FALSE;

	$clinic_phone = FALSE;

	

	$clinic_name = $cip[ 'ClinicName' ];

	$clinic_url = $cip[ 'ClinicInfoPackage' ][ 'ContactInfo' ][ 'ContactInfo' ][ 'WebsiteURL' ];

	$clinic_logo = $cip[ 'ClinicInfoPackage' ][ 'ClinicProfile' ][ '123dentistProfile' ][ 'Logo' ];

	$clinic_image = $cip[ 'ClinicInfoPackage' ][ 'ClinicProfile' ][ '123dentistProfile' ][ 'Image' ];

	$clinic_desc = sanitize_desciption( $cip[ 'ClinicInfoPackage' ][ 'ClinicProfile' ][ '123dentistProfile' ][ 'Description' ] );

	//$clinic_desc = $cip[ 'ClinicInfoPackage' ][ 'ClinicProfile' ][ '123dentistProfile' ][ 'Description' ];

	$clinic_address = array(

		'street' => $cip[ 'ClinicInfoPackage' ][ 'ContactInfo' ][ 'Address' ][ 'Street' ],

		'city' => $cip[ 'ClinicInfoPackage' ][ 'ContactInfo' ][ 'Address' ][ 'City' ],

		'province' => $cip[ 'ClinicInfoPackage' ][ 'ContactInfo' ][ 'Address' ][ 'Province' ],

		'postalcode' => $cip[ 'ClinicInfoPackage' ][ 'ContactInfo' ][ 'Address' ][ 'PostalCode' ],

		'country' => $cip[ 'ClinicInfoPackage' ][ 'ContactInfo' ][ 'Address' ][ 'Country' ],

	);

	$clinic_lat_lon = $cip[ 'ClinicInfoPackage' ][ 'ContactInfo' ][ 'Address' ][ 'GeoCoordinates' ];

	if(strpos($clinic_lat_lon, ',') !== false){

		$clinic_lat_lon_array = explode( ',', $clinic_lat_lon );

		$clinic_lat = $clinic_lat_lon_array[ 0 ];

		$clinic_lon = $clinic_lat_lon_array[ 1 ];

	}else{

		$clinic_lat = '';

		$clinic_lon = '';

	}

	$url_safe_clinic_name = urlencode( $clinic_name );

	$clinic_map = 'https://www.google.com/maps/search/?api=1&query=' . $url_safe_clinic_name . '&query_place_id=' . $cip[ 'ClinicInfoPackage' ][ 'ClinicProfile' ][ '123dentistProfile' ][ 'Map' ];

	$clinic_hours_array = array(

		'mon_open' 	=> get_hours_from_array( $cip[ 'ClinicInfoPackage' ][ 'OpeningHours' ][ 'ClinicHours' ][ 0 ], 'open' ),

		'mon_close' => get_hours_from_array( $cip[ 'ClinicInfoPackage' ][ 'OpeningHours' ][ 'ClinicHours' ][ 0 ], 'closed' ),

		'tue_open' 	=> get_hours_from_array( $cip[ 'ClinicInfoPackage' ][ 'OpeningHours' ][ 'ClinicHours' ][ 1 ], 'open' ),

		'tue_close' => get_hours_from_array( $cip[ 'ClinicInfoPackage' ][ 'OpeningHours' ][ 'ClinicHours' ][ 1 ], 'closed' ),

		'wed_open' 	=> get_hours_from_array( $cip[ 'ClinicInfoPackage' ][ 'OpeningHours' ][ 'ClinicHours' ][ 2 ], 'open' ),

		'wed_close' => get_hours_from_array( $cip[ 'ClinicInfoPackage' ][ 'OpeningHours' ][ 'ClinicHours' ][ 2 ], 'closed' ),

		'thu_open' 	=> get_hours_from_array( $cip[ 'ClinicInfoPackage' ][ 'OpeningHours' ][ 'ClinicHours' ][ 3 ], 'open' ),

		'thu_close' => get_hours_from_array( $cip[ 'ClinicInfoPackage' ][ 'OpeningHours' ][ 'ClinicHours' ][ 3 ], 'closed' ),

		'fri_open' 	=> get_hours_from_array( $cip[ 'ClinicInfoPackage' ][ 'OpeningHours' ][ 'ClinicHours' ][ 4 ], 'open' ),

		'fri_close' => get_hours_from_array( $cip[ 'ClinicInfoPackage' ][ 'OpeningHours' ][ 'ClinicHours' ][ 4 ], 'closed' ),

		'sat_open' 	=> get_hours_from_array( $cip[ 'ClinicInfoPackage' ][ 'OpeningHours' ][ 'ClinicHours' ][ 5 ], 'open' ),

		'sat_close' => get_hours_from_array( $cip[ 'ClinicInfoPackage' ][ 'OpeningHours' ][ 'ClinicHours' ][ 5 ], 'closed' ),

		'sun_open' 	=> get_hours_from_array( $cip[ 'ClinicInfoPackage' ][ 'OpeningHours' ][ 'ClinicHours' ][ 6 ], 'open' ),

		'sun_close' => get_hours_from_array( $cip[ 'ClinicInfoPackage' ][ 'OpeningHours' ][ 'ClinicHours' ][ 6 ], 'closed' ),

	);

	$clinic_hours = '';

	if( $clinic_hours_array[ 'mon_open' ] && $clinic_hours_array[ 'mon_open' ] != '' && $clinic_hours_array[ 'mon_open' ] != 'Closed' ){

		$clinic_hours .= 'Mo ' . $clinic_hours_array[ 'mon_open' ] . '-' . $clinic_hours_array[ 'mon_close' ];

	}else{

		$clinic_hours .= '';

	}

	if( $clinic_hours_array[ 'tue_open' ] && $clinic_hours_array[ 'tue_open' ] != '' && $clinic_hours_array[ 'tue_open' ] != 'Closed' ){

		$clinic_hours .= ' Tu ' . $clinic_hours_array[ 'tue_open' ] . '-' . $clinic_hours_array[ 'tue_close' ];

	}else{

		$clinic_hours .= '';

	}

	if( $clinic_hours_array[ 'wed_open' ] && $clinic_hours_array[ 'wed_open' ] != '' && $clinic_hours_array[ 'wed_open' ] != 'Closed' ){

		$clinic_hours .= ' We ' . $clinic_hours_array[ 'wed_open' ] . '-' . $clinic_hours_array[ 'wed_close' ];

	}else{

		$clinic_hours .= '';

	}

	if( $clinic_hours_array[ 'thu_open' ] && $clinic_hours_array[ 'thu_open' ] != '' && $clinic_hours_array[ 'thu_open' ] != 'Closed' ){

		$clinic_hours .= ' Th ' . $clinic_hours_array[ 'thu_open' ] . '-' . $clinic_hours_array[ 'thu_close' ];

	}else{

		$clinic_hours .= '';

	}

	if( $clinic_hours_array[ 'fri_open' ] && $clinic_hours_array[ 'fri_open' ] != '' && $clinic_hours_array[ 'fri_open' ] != 'Closed' ){

		$clinic_hours .= ' Fr ' . $clinic_hours_array[ 'fri_open' ] . '-' . $clinic_hours_array[ 'fri_close' ];

	}else{

		$clinic_hours .=  '';

	}

	if( $clinic_hours_array[ 'sat_open' ] && $clinic_hours_array[ 'sat_open' ] != '' && $clinic_hours_array[ 'sat_open' ] != 'Closed' ){

		$clinic_hours .= ' Sa ' . $clinic_hours_array[ 'sat_open' ] . '-' . $clinic_hours_array[ 'sat_close' ];

	}else{

		$clinic_hours .= '';

	}

	if( $clinic_hours_array[ 'sun_open' ] && $clinic_hours_array[ 'sun_open' ] != '' && $clinic_hours_array[ 'sun_open' ] != 'Closed' ){

		$clinic_hours .= ' Su ' . $clinic_hours_array[ 'sun_open' ] . '-' . $clinic_hours_array[ 'sun_close' ];

	}else{

		$clinic_hours .= '';

	}

	if( $cip[ 'ClinicInfoPackage' ][ 'ContactInfo' ][ 'ContactInfo' ][ 'Telephone' ] && $cip[ 'ClinicInfoPackage' ][ 'ContactInfo' ][ 'ContactInfo' ][ 'Telephone' ] != '' )

	{

	$clinic_phone_raw = '+1' . $cip[ 'ClinicInfoPackage' ][ 'ContactInfo' ][ 'ContactInfo' ][ 'Telephone' ];

		if(  preg_match( '/^\+\d(\d{3})(\d{3})(\d{4})$/', $clinic_phone_raw,  $matches ) )

        {

                $clinic_phone = '+1 (' . $matches[1] . ') ' .$matches[2] . '-' . $matches[3];

                //return $clinic_phone;

        }

	}

	// Uncomment the line below to output the cip wrapped in cdata into the head of the website

	//echo '<div id="cip-output" style="display:none;"><![CDATA[';print_r( $cip );echo ']]></div>';

	

	$cip_for = array();

	global $cip_for;

	$cip_for[ 'clinic_name' ] = $clinic_name;

	$cip_for[ 'clinic_url' ] = $clinic_url;

	$cip_for[ 'clinic_logo' ] = $clinic_logo;

	$cip_for[ 'clinic_image' ] = $clinic_image;

	$cip_for[ 'clinic_desc' ] = $clinic_desc;

	$cip_for[ 'clinic_lat' ] = $clinic_lat;

	$cip_for[ 'clinic_lon' ] = $clinic_lon;

	$cip_for[ 'clinic_lat_lon' ] = $clinic_lat_lon;

	$cip_for[ 'clinic_map' ] = $clinic_map;

	$cip_for[ 'clinic_phone' ] = $clinic_phone;

	$cip_for[ 'clinic_phone_raw' ] = $clinic_phone_raw;

	$cip_for[ 'clinic_address' ] = $clinic_address;

	$cip_for[ 'clinic_hours' ] = $clinic_hours_array;

	



	if( $clinic_url ): 

	

	?>

	<script type='application/ld+json'> 

	{

	  "@context": "http://www.schema.org",

	  "@type": "Dentist",

	  "name": "<?php echo $clinic_name; ?>",

	  "url": "<?php echo $clinic_url; ?>",

	  "logo": "<?php echo $clinic_logo; ?>",

	  "image": "<?php echo $clinic_image; ?>",

	  "description": "<?php echo $clinic_desc; ?>",

	  "address": {

		"@type": "PostalAddress",

		"streetAddress": "<?php echo $clinic_address[ 'street' ]; ?>",

		"addressLocality": "<?php echo $clinic_address[ 'city' ]; ?>",

		"addressRegion": "<?php echo $clinic_address[ 'province' ]; ?>",

		"postalCode": "<?php echo $clinic_address[ 'postalcode' ]; ?>",

		"addressCountry": "<?php echo $clinic_address[ 'country' ]; ?>"

	  },

	  "geo": {

		"@type": "GeoCoordinates",

		"latitude": "<?php echo $clinic_lat; ?>",

		"longitude": "<?php echo $clinic_lon; ?>"

	  },

	  "hasMap": "<?php echo $clinic_map; ?>",

	  "openingHours": "<?php echo $clinic_hours; ?>"

	  <?php if( $clinic_phone ): ?>,

	  "contactPoint": {

		"@type": "ContactPoint",

		"telephone": "<?php echo $clinic_phone; ?>",

		"contactType": "customer service"

	  }

	  <?php endif; ?>

	}

 	</script>

 <?php 

	endif;

}



?>